//
//  GSGlyphInfo.h
//  Glyphs
//
//  Created by Georg Seifert on 20.1.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <GlyphsCore/GSFont.h>

/** \brief GSGlyphInfo: The class defining the glyphinfo object
 \ingroup common
 This class defines the glyphinfo object.
 */
@interface GSGlyphInfo : NSObject <NSCopying>
/// The glyph name.
@property (strong, nonatomic) NSString *name;
/// The category of the glyph.
/**
This is mostly from the UnicodeData.txt file from unicode.org. Some corrections have been made (Accents, ...)
e.g: "Letter", "Number", "Punctuation", "Mark", "Separator", "Symbol", "Other"
*/
@property (strong, nonatomic) NSString *category;

/// The subcategory of the glyph.
/**
 This is mostly from the UnicodeData.txt file from unicode.org. Some corrections and additions have been made
 e.g: "Ligature", "Decimal Digit", ...
 */
@property (strong, nonatomic) NSString *subCategory;

#ifndef GLYPHS_VIEWER
/** The case of the glyph

 Like Uppercase, Lowercase, smallcaps
 */
- (GSCase)case;
- (void)setCase:(GSCase)aCase;

/// The Glyph is composed from this glyphs.
/**
f_f_i > f f i
Adieresis > A dieresis
*/
@property (strong, nonatomic) NSArray<GSGlyphInfo *> *components;

@property (readonly, nonatomic) NSUInteger countOfComponents;

- (void)setComponentNames:(NSArray<NSString *> *)componentNames;

@property (strong, nonatomic) NSString *baseString;

- (void)updateBaseString:(GSGlyphsInfo *)glyphInfo;

/// The Glyph can be combined with this accents.
/**
a > dieresis, grave, acute ...
*/
@property (strong, nonatomic) NSArray *marks;

/// The anchors of the glyph.
/**
e.g: "top", "ogonek"
*/
@property (strong, nonatomic) NSArray *anchors;

/// The unicode value.
/**
as a hex string.
*/
@property (strong, nonatomic) NSOrderedSet<NSString *> *unicodes;

@property (strong, nonatomic) NSString *unicodeLegacy;

- (NSUInteger)countOfUnicodes;

@property (readonly, nonatomic) NSString *unicode;

- (void)addUnicode:(NSString *)unicode;

@property (strong, nonatomic) NSString *unicharString;

@property (readonly, nonatomic) UTF32Char unicodeChar;
/// The script.
/**
e.g: "Latin", "Cyrillic", "Greek"
*/
@property (strong, nonatomic) GSScriptID script;

/// Name to use on export
/**
acyrill > afii10065
*/
@property (strong, nonatomic) NSString *production;
#endif

@property (nonatomic) GSWritingDirection direction;
+ (NSString *)stringFromDirection:(GSWritingDirection)direction;
+ (GSWritingDirection)directionFromString:(NSString *)directionString;
+ (NSString *)stringFromCase:(GSCase)aCase;
+ (GSCase)caseFromString:(NSString *)caseString;
+ (NSString *)localizedStringFromCase:(GSCase)aCase;

#ifndef GLYPHS_VIEWER
@property (nonatomic) NSUInteger index;
@property (strong, nonatomic) NSString *sortName;
@property (strong, nonatomic) NSString *sortNameKeep;
@property (strong, nonatomic) NSString *desc;
@property (nonatomic, strong) NSArray *altNames;

- (NSString *)componentsString;

#if DEBUG
- (id)initWithLine:(NSString *)line;

- (NSString *)line;
#endif

@property BOOL locked;
#endif
@end
